#!/bin/sh
if [ ! -f /etc/debian_version ]; then
    echo "Debian Wheezy required. Stopping."
    exit 1
fi
dpkg --compare-versions $(cat /etc/debian_version) lt 7.0 || dpkg --compare-versions $(cat /etc/debian_version) ge 8.0
if [ $? -eq 0 ]; then
    echo "Debian Wheezy required. Stopping."
    exit 1
fi

echo "net.ipv4.ip_nonlocal_bind=1" | tee -a /etc/sysctl.conf
echo "fs.file-max=3355444" | tee -a /etc/sysctl.conf
echo "vm.swappiness=1" | tee -a /etc/sysctl.conf
echo "KOHANA_ENV=production" | tee -a /etc/environment

apt-get update
apt-get install -y git supervisor
apt-get install -y php5-cli php5-mcrypt php5-mysql php5-pgsql

cd ~
wget https://launchpad.net/gearmand/1.2/1.1.12/+download/gearmand-1.1.12.tar.gz
tar xzvf gearmand-1.1.12.tar.gz
cd gearmand-1.1.12
apt-get install -y checkinstall libpq-dev libcloog-ppl-dev uuid-dev libevent-dev gperf libboost-all-dev
mkdir -p /usr/include/libgearman-1.0
./configure --prefix=/usr
make && checkinstall -D
if [ $? -eq 0 ]; then
    echo "Could not install gearmand. Stopping."
    exit 1
fi

apt-get install -y php5-dev php-pear
mount -o remount,exec,suid,dev /tmp/
pecl install -f gearman
mount -o remount /tmp/
echo "extension=gearman.so" > /etc/php5/mods-available/gearman.ini
ln -s /etc/php5/mods-available/gearman.ini /etc/php5/cli/conf.d/20-gearman.ini

apt-get install -y libmysqlclient18 libodbc1 libpq5
cd ~
wget http://sphinxsearch.com/files/sphinxsearch_2.2.10-release-1~wheezy_amd64.deb
dpkg -i sphinxsearch_2.2.10-release-1~wheezy_amd64.deb
rm sphinxsearch_2.2.10-release-1~wheezy_amd64.deb
sed -i 's/START\s*=\s*yes/START=no/' /etc/default/sphinxsearch

cd /var/www
/usr/bin/php index.php --task=indexer:prepare
